#pragma once
#include <glut.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <algorithm>
#include <vector>
#include <memory>
#include "Light.h"
#include "SpotLight.h"

class LightManager
{
	public:
		LightManager();
		~LightManager();

		void AddNewLight(Light* light);	//Add a new light to the list
		void UpdateAll(float dt);	//Update all the lights
		void RenderAll();	//Render all the lights

		void ToggleLight(Light* light);	//Toggle light on/off

	protected:
		std::vector<Light*> _Lights;
};

